% Цей файл містить усі налаштуванню стилю та форматування статті. Не змінюйте його

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{kau-ukr}[2025/03/01
v1.0 Document class for KAU]
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass[11pt,twoside]{article}
\PassOptionsToPackage{utf8}{inputenc}
\PassOptionsToPackage{english,ukrainian}{babel}
\RequirePackage{cmap}
\RequirePackage{amsmath}
\RequirePackage{inputenc}
\RequirePackage{babel}
\RequirePackage{amsthm}
\RequirePackage{amsmath}
\RequirePackage{latexsym}
\RequirePackage{amssymb}
\RequirePackage{amscd}
\RequirePackage{epsfig}
\RequirePackage{graphics}
\RequirePackage{ifthen}
\RequirePackage{varioref}
\RequirePackage{cite}
\RequirePackage{zref-totpages}
\RequirePackage{pgf}
\RequirePackage{tikz}
\RequirePackage{listings}
\RequirePackage[labelsep=period]{caption}
\usepackage{color}
\ifpdf
  \usepackage[
    pdftex,
    colorlinks,%
    linkcolor=blue,citecolor=red,urlcolor=blue,
    hyperindex,%
    plainpages=false,%
    bookmarksopen,%
    bookmarksnumbered%
  ]{hyperref}
  %%?? \def\pdfBorderAttrs{/Border [0 0 0] } % No border arround Links
%  \usepackage{thumbpdf}
\else
  \usepackage[hypertex]{hyperref}
\fi

%\let\WriteBookmarks\relax
%\let\WriteBookmarksnumbered\relax
%\let\WritePdfpagelabels\relax
%\let\pageref\HyPsd@pageref

% Beginning initialization

\newcommand{\ArticleLabel}{Article label}
\newcommand{\evenhead}{Author \ name}
\newcommand{\oddhead}{Article \ name}
\newcommand{\theArticleName}{Article name}
\newcommand{\ArticleNumber}{01.001}
\newcommand{\PublicationYear}{2025}




% Titlepage

\newcommand{\FirstPageHeading}[1]{\thispagestyle{empty}%
\noindent\raisebox{24pt}[0pt][0pt]{\makebox[\textwidth]{\protect\footnotesize \sf
Праці наукової конференції \hfill KyivAcademUs, \PublicationYear, \ArticleNumber,
\ztotpages~стор.}}\par}

\newcommand{\LastPageEnding}{\label{\ArticleLabel-lp}\newpage}

\newcommand{\ArticleName}[1]{\renewcommand{\theArticleName}{#1}\vspace{-7mm}\par\noindent {\LARGE\bf  #1\par}}
\newcommand{\Author}[1]{\vspace{5mm}\par\noindent {\it #1} \par\vspace{2mm}\par}
\newcommand{\Address}[1]{\vspace{2mm}\par\noindent {\it #1} \par}
\newcommand{\Email}[1]{\ifthenelse{\equal{#1}{}}{}{\par\noindent {\rm E-mail: }{\href{mailto:#1}{#1}} \par}}
\newcommand{\orcid}[1]{\ifthenelse{\equal{#1}{}}{}{\par\noindent {\rm ORCID: }{\href{https://orcid.org/#1}{https://orcid.org/#1}} \par}}
\newcommand{\URLaddressMarked}[1]{\ifthenelse{\equal{#1}{}}{}{\par\noindent $^*$~{\rm URL: }{\tt  #1} \par}}
\newcommand{\EmailD}[1]{\ifthenelse{\equal{#1}{}}{}{\par\noindent {$\phantom{^{{\rm 1)}}}$~\rm E-mail: }{\href{mailto:#1}{#1}} \par}}
\newcommand{\orcidD}[1]{\ifthenelse{\equal{#1}{}}{}{\par\noindent {$\phantom{^{{\rm 1)}}}$~\rm ORCID: }
{\href{https://orcid.org/#1}{https://orcid.org/#1}} \par}}
\newcommand{\ArticleDates}[1]{\vspace{2mm}\par\noindent {\small {\rm #1} \par
\noindent
{\href{https://doi.org/10.3842/kau.\PublicationYear.\ArticleNumber}{https://doi.org/10.3842/confKAU.\PublicationYear.\ArticleNumber}
}} \par}
\newcommand{\Abstract}[1]{\vspace{6mm}\par\noindent\hspace*{10mm}
\parbox{140mm}{\small {\bf Анотація.} #1}\par}

\newcommand{\AbstractEng}[1]{\vspace{6mm}\par\noindent\hspace*{10mm}
\parbox{140mm}{\small {\bf Abstract.} #1}\par}

\newcommand{\Keywords}[1]{\vspace{3mm}\par\noindent\hspace*{10mm}
\parbox{140mm}{\small {\it Ключові слова:} \rm #1}\par}
\newcommand{\Classification}[1]{\vspace{3mm}\par\noindent\hspace*{10mm}
\parbox{140mm}{\small {\it 2020 Mathematics Subject Classification:} \rm #1}\vspace{3mm}\par}

\newcommand{\KeywordsEng}[1]{\vspace{3mm}\par\noindent\hspace*{10mm}
\parbox{140mm}{\small {\it Keywords:} \rm #1}\par}


\newcommand{\ShortArticleName}[1]{\renewcommand{\oddhead}{#1}}
\newcommand{\AuthorNameForHeading}[1]{\renewcommand{\evenhead}{#1}}

% Set head and foot

\renewcommand{\@evenhead}{
\hspace*{-3pt}\raisebox{-15pt}[\headheight][0pt]{\vbox{\hbox to \textwidth
{\thepage \hfil \evenhead}\vskip4pt \hrule}}}
\renewcommand{\@oddhead}{
\hspace*{-3pt}\raisebox{-15pt}[\headheight][0pt]{\vbox{\hbox to \textwidth
{\oddhead \hfil \thepage}\vskip4pt\hrule}}}
\renewcommand{\@evenfoot}{}
\renewcommand{\@oddfoot}{}


% Papersize

\setlength{\textwidth}{160.0mm}
\setlength{\textheight}{240.0mm}
\setlength{\oddsidemargin}{5mm}
\setlength{\evensidemargin}{5mm}
\setlength{\topmargin}{-18mm}
\setlength{\parindent}{5.0mm}

% This makes the Figure/Table text a little smaller and makes the
% number boldface.

\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{\small \textbf{#1.}\ \ #2}%
  \ifdim \wd\@tempboxa >\hsize
    {\small \textbf{#1.}\ \ #2}\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}


% Defines the \numberwithin command from AMS-LaTeX
%
\def\numberwithin#1#2{\@ifundefined{c@#1}{\@nocounterr{#1}}{%
  \@ifundefined{c@#2}{\@nocnterr{#2}}{%
  \@addtoreset{#1}{#2}%
  \toks@\@xp\@xp\@xp{\csname the#1\endcsname}%
  \@xp\xdef\csname the#1\endcsname
    {\@xp\@nx\csname the#2\endcsname
     .\the\toks@}}}}

% Proof should be boldface
%
\renewenvironment{proof}[1][\proofname]{\par
  \normalfont
  \topsep6\p@\@plus6\p@ \trivlist
  \item[\hskip\labelsep\textbf{%
    #1}\@addpunct{\bf .}]\ignorespaces
}{%
  \qed\endtrivlist
}
%\renewcommand{\qedsymbol}{$\blacksquare$}


% Theorem-like environment
%
\newtheorem{theorem}{Теорема}
\newtheorem*{theorem*}{Теорема}
\newtheorem{lemma}[theorem]{Лема}
\newtheorem*{lemma*}{Лема}
\newtheorem{corollary}[theorem]{Наслідок}
\newtheorem*{corollary*}{Наслідок}
\newtheorem{proposition}[theorem]{Твердження}
\newtheorem*{proposition*}{Твердження}
\newtheorem{conjecture}[theorem]{Гіпотеза}
\newtheorem*{conjecture*}{Гіпотеза}
{\theoremstyle{definition} \newtheorem{definition}[theorem]{Означення}
\newtheorem*{definition*}{Означення}
\newtheorem{example}[theorem]{Приклад}
\newtheorem*{example*}{Приклад}
\newtheorem{remark}[theorem]{Зауваження}
\newtheorem*{remark*}{Зауваження}
}

% Vertical space in tables
\def\tsep#1{%
  {\@tempdima=\ht\strutbox\advance\@tempdima #1
   \vrule height \@tempdima depth 0pt width 0pt\nobreak\hspace{0pt}%
  }%
}
\def\bsep#1{%
  {\@tempdima=\dp\strutbox \advance\@tempdima #1
   \nobreak\hspace{0pt}\vrule height 0pt depth \@tempdima width 0pt
  }%
}


\endinput
